/*
 * processmanager.h: stores process information and does some basic process management.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __processmanager_h_
#define __processmanager_h_

// c headers
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

class processManager
{
    public:
        processManager(const char *commnd, char** args);
        ~processManager(void);

        // access to the file descriptor
        int getfd(void);

        // read & write
        int read(void *buffer, int size);
        int write(void *buffer, int size);

        // exceptions
        class processManagerFailedFork { };
        class processManagerFailedExec { };

    private:
        int fileDescriptor;
        pid_t processID;
        processManager();       // hidden and unimplemented
        int processStatus;
};

#endif /* __processmanager_h_ */
