/*
 * primepool.h: maintains a set of safe prime numbers
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __primepool_h_
#define __primepool_h_

class primePool
{
    public:
        primePool(void);
        ~primePool(void);

        void generate(int nbits);
        struct BigNum *getPrime(int nbits);

        void remove(struct BigNum *p);
    private:
        class primeSet
        {
            public:
                primeSet(struct BigNum *p, primeSet *next);
                ~primeSet(void);

                struct BigNum *prime;
                primeSet *nextPrime;
        } *primePoolSet;

        void add(struct BigNum *p);
};

#endif /* __primepool_h_ */
