/*
 * pipemanager.h: a simple class to keep track of open pipes
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __pipemanager_h_
#define __pipemanager_h_

#include "processmanager.h"

class pipeManager
{
    public:
        class pipeElement
        {
            public:
                pipeElement(processManager *processInfo, pipeElement *next = NULL);
                ~pipeElement(void);

                int getfd(void);

                bool queued;
                processManager *process;
                pipeElement *nextElement;
        } *elements;

        pipeManager(processManager *processInfo);
        ~pipeManager(void);

        void add(processManager *processInfo);
        void remove(int fd);
};

#endif /* __pipemanager_h_ */
