/*
 * olympus.h
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __olympus_h_
#define __olympus_h_

#include <iostream>
#include <string>

/* file paths which may be changed at or during runtime */
extern string *configPath;
extern string *dataPath;
extern string *descriptorPath;

extern bool restartPending;
extern bool shutdownPending;

/* various external classes that we use */
class olympusConfig;
class logStream;
class transport;
class channel;
class manager;
class userManager;
class primePool;
class sysBackup;
class sequence;
class packageManager;

/* set of primes */
extern primePool *primeSet;

/* system databases */
extern manager *sysManager;
extern userManager *sysUsers;
extern sysBackup *backupManager;
extern packageManager *sysPackages;
extern sequence serverSequence;

/* log streams */
extern logStream errorLog;

class olympus
{
    public:
        olympus(void);
        
        void serverMain(void);
    private:
        olympusConfig *config;
        transport *socket;
        channel *clients;

        void checkPath(string *path);

        void setBasePath(void);
        void setConfigPath(void);
        void setDataPath(void);
        void setDescriptorPath(void);
        void setTmpDataPath(void);

        char *getServerHost(void);
        int getServerPort(void);

        void initDatabases(void);

        int setPipes(channel* client, fd_set* fd_in);

        void addClient(int sd);
        void removeClient(channel *client);

        void serverLoop(void);
};

#endif /* __olympus_h_ */
