/*
 * logstream.h:
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __logstream_h_
#define __logstream_h_

#include <syslog.h>

#define LOG_BUFFER_SIZE 1024

class ostream;

class logStream
{
    public:
        logStream(const char* ident, int priority);

        logStream& operator<<(const char* str);
        logStream& operator<<(string* str);
        logStream& operator<<(int d);
        logStream& operator<<(ostream&(*f)(ostream&));
    private:
        void concatenate(const char* str);
        void log(void);

        int length;
        int level;
        char buffer[LOG_BUFFER_SIZE];
};

#endif /* __logstream_h_ */
