/*
 * channel.h: a class to record client connections
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __channel_h_
#define __channel_h_

class netmessage;
class transport;
class processManager;
class pipeManager;

class channel
{
    public:
        channel(int nsd);
        ~channel(void);

        int getsd(void);
        int processChannel(void);
        int processPipes(fd_set* fd_in = NULL);

        pipeManager *pipeList;              /* open pipes */
        channel *next;                      /* next client in list */

    private:
        void addProcess(processManager *process);

        int processGeneric(void);           /* process generic op code */
        int processConnect(void);           /* process connection op code */
        int processAex(void);               /* algorithm negotiation */
        int processKex(void);               /* key exchange */
        int processAuth(void);              /* user authentication */
        int processRequest(void);           /* data requests */

        int pipeMessage(void);

        transport *socket;

        int state;                          /* session state */

        unsigned char header[32];           /* netmessage header */
        int hlen;                           /* header position */

        uint32 opcode;                      /* operation code */
        uint32 sessionID;                   /* session id */
        uint32 commandID;                   /* command id */

        netmessage *request;                /* user request */

        int pipeQueue;
};

#endif /* __channel_h_ */
