/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * pidList.h
 *
 * Provide definitions for linked list of pid's.
 *****************************************************************/

#ifndef _pidlist_h_
#define _pidlist_h_

#include <sys/types.h>
#include <sys/wait.h>

class pidList
{
 public:
    pidList(const pid_t pid);
    ~pidList();
    void add(const pid_t pid);
    void remove(const pid_t pid);
    void reap();
    int getStatus() {return (this->status);}
    pidList *nextpid;

 private:
    pidList();
    pid_t pid;
    int status;
};

#endif
