/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * pidList.cc
 *
 * Provide implementation for linked list of pid's.
 *****************************************************************/

#include "pidList.h"

pidList::pidList(const pid_t pid)
{
    this->pid = pid;
    status = 0;
    nextpid = 0;
}

pidList::~pidList()
{
    if (this->nextpid)
    {
        delete this->nextpid;
    }
}

void pidList::add(const pid_t pid)
{
    pidList *lastpid = this;

    while (lastpid->nextpid)
    {
        lastpid = lastpid->nextpid;
    }

    lastpid = new pidList(pid);
}

void pidList::remove(pid_t pid)
{
    pidList *pidptr = this;
    pidList *lastptr = this;
    bool found;

    while (pidptr && !found)
    {
        lastptr = pidptr;
        pidptr = pidptr->nextpid;
        found = (pidptr->pid == pid);
    }

    if (found)
    {
        lastptr->nextpid = pidptr->nextpid;
    }
}

void pidList::reap()
{
    pidList* pidptr = this;
    pid_t pid;

    while (pidptr)
    {
        pid = waitpid(pidptr->pid, &(pidptr->status), 0);
        pidptr = pidptr->nextpid;
    }
}
