//****************************************************************
// olyexec.cc:
//
// Copyright (c) 1999-2000 Mount Linux Inc.
// Licensed under the terms of the GPL
//****************************************************************

//****************************************************************
// This is the helper program for executing an arbitrary command
// from the server.
//
// Command Line Arguments:
//
// 1 - command id.     This is emitted in the output.  The server
//                     uses this to instantiate the right
//                     netmessage to return.
// 2 - session id.     This is emitted in the output and is used
//                     to determine which session the process
//                     replies to.
// 3 - execution path. For commands executed by the server this
//                     path is inserted into path as the first
//                     element.
// 4 - execution dir.  For commands excuted by the server this is
//                     the directory that they execute in.
// 5 - cmmd.           A list of the command to be executed
//                     followed by its arguments.
//****************************************************************

// c library headers
#include <stdlib.h>

// c++ standard library
#include <iostream>

// class files
#include <exec.h>

static void usage(void)
{
    cout << "usage: olyexec sessionid commandid execpath tmppath" << endl
         << "       - or -" << endl
         << "       olyexec sessionid commandid ERROR status" << endl;
    exit(0);
}

// pass an error back to the waiting process
int returnError(char *sessionstr, char *cmdstr, char *statstr)
{
    char buffer[128];
    char *p;
    int fd;
    int sessionID;
    int commandID;
    int length;
    int status;
    int zero;

    sessionID = atoi(sessionstr);
    commandID = atoi(cmdstr);
    status = atoi(statstr);
    length = 0;
    zero = 0;
    fd = fileno(stdout);
    p = buffer;

    memcpy(p, (char *) &sessionID, sizeof(int));
    p += sizeof(int);

    memcpy(p, (char *) &commandID, sizeof(int));
    p += sizeof(int);

    memcpy(p, (char *) &zero, sizeof(int));
    p += sizeof(int);

    memcpy(p, (char *) &zero, sizeof(int));
    p += sizeof(int);

    memcpy(p, (char *) &status, sizeof(int));
    p += sizeof(int);

    memcpy(p, (char *) &length, sizeof(int));
    p += sizeof(int);

    write(fd, buffer, p - buffer);

    return 0;
}

int main(int argc, char **argv)
{
    string rtnvalue;
    if (argc < 4)
    {
        usage();
    }
    if (strcmp("ERROR", argv[3]) == 0)
    {
        rtnvalue = returnError(argv[1], argv[2], argv[4]);
    }
    else
    {
        Exec exec(argv[1], argv[2], argv[3], argv[4]);
        exec.ExecChain(argc - 5, &argv[5]);
        exec.Output();
    }
    return (0);
}
