//****************************************************************
// exec.h
//
// Copyright (c) 1999-2000 Mount Linux Inc.
// Licensed under the terms of the GPL
//
// Class that executes commands in a list of arguments provided
// to the constructor.  The commands will execute and status
// from the child processes is reported in the output.  The
// output from the commands follows the status.
//****************************************************************

#ifndef _exec_h_
#define _exec_h_

// c header files
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <fcntl.h>
#include <dirent.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>

// c++ stdlib
#include <iostream>
#include <string>
#include <list>

// olympus headers
#include "regexx.hh"
#include "pidList.h"
    
class Exec
{
 private:
    pidList* pidlist;           // linked list for processes
    struct timeval start;       // initial time stamp for execution
    struct timeval end;         // final time stamp of execution
    struct timeval elapsedTime; // the final elapsed time
    string execpath;            // path for extra programs
    string temppath;            // location for execution
    string pipedata;            // data from stdout
    int filedesc;               // file descriptor from pipe
    int commandID;              // netmessage to give back to the daemon
    int sessionID;              // session this process belongs to
    int status;                 // process status

    Exec();                     // its not implemented
    // private methods
    string* CaptureOutput();
    void check_the_arguments(int argc, char **arglist, char **cmdlist);
    bool CheckArguments(char *, ...);
    void EmitIncomplete();
    string *FindFile();
    void MakeEnvironment();
    void makeitblock(int fd);
    pid_t ExecChild(int rd0, int wr0, int rd1, int wr1, char **cmd);
    int ExecChild1(int, int, int, int, const char*, char **);

 public:
    Exec(char *sessidStr, char *netmsgIDStr, char *execPath, char *tmpPath);
    ~Exec();
    void ExecChain(int argc, char **cmd);
    void Output();

    // exceptions
    class blockexception { };
};

#endif
