#ifndef APPLICATION_H
#define APPLICATION_H

#include <qmainwindow.h>
#include <qtextbrowser.h>
#include <qmime.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qheader.h>

#include "qstackbar.h" //this isn't part of QT it's found in olympus/src/common/GNU/stackbar
#include "qstackbarbtn.h" // Same deal here ^^^^
#include "config.h"
#include "ktreeview.h"

class QToolBar;
class QPopupMenu;

class ApplicationWindow: public QMainWindow
{
    Q_OBJECT
public:
    ApplicationWindow();
    ~ApplicationWindow();
    
protected:
    void closeEvent( QCloseEvent* );

private slots:
    void about();
    void aboutQt();
    
private:
    void buildIndex(KTreeView* list, QString directory);
    
    QTextBrowser * mainViewer;
    QToolBar *fileTools;
    QString filename;
    QMimeSourceFactory * factory;
    QWidget * mainWidget;
    QGridLayout * grid;
    QStackBar * stackBar;
    KTreeView * clientTree;
    KTreeView * serverTree;
    KTreeView * pluginTree;
    KTreeView * apiTree;
    KTreeView * miscTree;
};


#endif
