#include "application.h"

#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qmultilineedit.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qmainwindow.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qwhatsthis.h>
#include <qstringlist.h>

ApplicationWindow::ApplicationWindow()
    : QMainWindow( 0, "Olympus Help", WDestructiveClose )
{
    mainWidget = new QWidget(this);
    grid = new QGridLayout(mainWidget, 0, 0);
    grid->addRowSpacing(0, 500); 
    stackBar = new QStackBar( mainWidget, "Bob" );

    fileTools = new QToolBar( this, "file operations" );
    fileTools->setLabel( tr( "File Operations" ) );

    (void)QWhatsThis::whatsThisButton( fileTools );

    QPopupMenu * file = new QPopupMenu( this );
    menuBar()->insertItem( "&File", file );

    file->insertItem( "&Close", this, SLOT(close()), CTRL+Key_W );
    file->insertItem( "&Quit", qApp, SLOT( closeAllWindows() ), CTRL+Key_Q );

    QPopupMenu * help = new QPopupMenu( this );
    menuBar()->insertSeparator();
    menuBar()->insertItem( "&Help", help );

    help->insertItem( "&About", this, SLOT(about()), Key_F1 );
    help->insertItem( "About &Qt", this, SLOT(aboutQt()) );
    help->insertSeparator();
    help->insertItem( "What's &This", this, SLOT(whatsThis()), SHIFT+Key_F1 );
    
    QStringList paths;
    paths.append(OLYMPUS_HELP_PATH "/txt/");
    paths.append(OLYMPUS_HELP_PATH "/xml/");
    paths.append(OLYMPUS_HELP_PATH "/pixmaps/");
    
    factory = new QMimeSourceFactory();
    factory->defaultFactory();
    factory->setFilePath(paths);
    
    clientTree = new KTreeView( mainWidget, "Client" );
    buildIndex(clientTree, paths[1] + "client/");
    
    serverTree = new KTreeView( mainWidget, "Server" );
    buildIndex(serverTree, paths[1] + "server/");
    
    pluginTree = new KTreeView( mainWidget, "Plugins" );
    buildIndex(pluginTree, paths[1] + "plugins/");
    
    apiTree = new KTreeView( mainWidget, "API" );
    buildIndex(apiTree,  paths[1] + "api/");
    
    miscTree = new KTreeView( mainWidget, "Miscellaneous" );
    buildIndex(miscTree, paths[1] + "misc/");
   
    grid->addColSpacing(0, 150);
        stackBar->addPage( new QStackBarBtn( "Client", clientTree ));
        stackBar->addPage( new QStackBarBtn( "Server", serverTree ));
        stackBar->addPage( new QStackBarBtn( "Plugins", pluginTree ));
        stackBar->addPage( new QStackBarBtn( "API", apiTree ));
        stackBar->addPage( new QStackBarBtn( "Miscellaneous", miscTree ));
    grid->addWidget( stackBar, 0, 0 );
    stackBar->setCurPage(0);
    
    grid->addColSpacing(1, 150);
        mainViewer = new QTextBrowser( mainWidget, "viewer" );
        mainViewer->setFocus();
        mainViewer->setMimeSourceFactory ( factory );
        mainViewer->setSource("main.xml");
    grid->addWidget( mainViewer, 0, 1);
    
    setCentralWidget( mainWidget );
    statusBar()->message( "Ready", 2000 );
    resize( 700, 600 );
}

ApplicationWindow::~ApplicationWindow() { }

void ApplicationWindow::closeEvent( QCloseEvent* ce )
{
    ce->accept();
    return;
}


void ApplicationWindow::about()
{
    QMessageBox::about( this, "About Olympus Help",
			"This application is used as the Olympus"
			"Help System.");
}


void ApplicationWindow::aboutQt()
{
    QMessageBox::aboutQt( this, "About Qt" );
}

void ApplicationWindow::buildIndex(KTreeView* list, QString directory)
{
    /* this will read in the contents of directory
       and build and index in list */
}
