/*
 * send.cc: send a message to the socket
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "cipher.h"
#include "transport.h"

int transport::send(const void* ptr, int len)
{
    int rlen;

    if (encipher != NULL)
    {
        unsigned char* buffer, *nptr, *src((unsigned char*) ptr);
        char padding(8 - ((len + 5) & 7));
        uint32 length(len + padding + 5), nlength(length);
        int i;

        buffer = new unsigned char[length];

        nlength = htonl(nlength);
        memcpy(buffer, &nlength, 4);
        nptr = &buffer[4];

        *(nptr++) = padding;

        for (i = 0; i < len; i++)
        {
            *(nptr++) = *(src++);
        }

        for (i = 0; i < padding; i++)
        {
            *(nptr++) = padding;
        }

        encipher->encrypt(buffer, buffer, length);

        do {
            rlen = ::write(sd, buffer, length);
        } while (rlen == -1 && errno == EINTR);

        delete[] buffer;
    }
    else
    {
        do {
            rlen = ::write(sd, ptr, len);
        } while (rlen == -1 && errno == EINTR);
    }
    return rlen;
}
