/*
 * recv.cc: receive a message from a socket
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "cipher.h"
#include "transport.h"

int transport::recv(void* ptr, int len)
{
    int rlen(0);

    if (decipher != NULL)
    {
        unsigned char* tmp, *dptr((unsigned char*) ptr);
        int rv, dlen;

        if (packet_length == 0)
        {
            if ((rv = ::read(sd, &header[packet_read], 8 - packet_read)) < 1)
            {
                return rv;
            }

            if ((packet_read = packet_read + rv) == 8)
            {
                decipher->decrypt(&header[0], &header[0], 8);
                memcpy(&packet_length, &header[0], 4);
                packet_length = ntohl(packet_length);

                if (packet_length < 32768)
                {
                    padding_length = header[4];
                    buffer = new unsigned char[packet_length];
                    bptr = &buffer[5];

                    memcpy(buffer, &header[0], 8);
                }
                else
                {
                    return -1;
                }
            }
            else
            {
                errno = EAGAIN;
                return -1;
            }
        }

        if (packet_read != packet_length)
        {
            if ((rv = ::read(sd, buffer + packet_read, packet_length - packet_read)) < 1)
            {
                return rv;
            }

            tmp = buffer + packet_read - (packet_read & 7);
            dlen = (packet_read & 7) + rv;
            packet_read = packet_read + rv;
            decipher->decrypt(tmp, tmp, dlen - (dlen & 7));
            tmp = buffer + packet_read - (packet_read & 7);
        }
        else
        {
            tmp = buffer + packet_length - padding_length;
        }

        if (bptr < tmp)
        {
            while (rlen < len && bptr < tmp)
            {
                *(dptr++) = *(bptr++);
                rlen++;
            }

            if (packet_read == packet_length && bptr - buffer == packet_length - padding_length)
            {
                delete buffer;

                packet_length = packet_read = padding_length = 0;
                bptr = buffer = NULL;
            }
            return rlen;
        }
        else
        {
            errno = EAGAIN;
            return -1;
        }
    }
    else
    {
        do {
            rlen = ::read(sd, ptr, len);
        } while (rlen == -1 && errno == EAGAIN);

        return rlen;
    }
}
