#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

// the parent just exits and proceeds to make a client
int createserver(char *server, int fd)
{
    int fv;
    int rc;
    fv = fork();
    switch (fv)
    {
    case -1:
        perror("fork");
        exit(1);
        break;
    case 0:
        if (fd != 0)
        {
            rc = dup2(fd, 0);
            if (rc)
            {
                perror("server dup");
                exit(1);
            }
        }
        execlp(server, server, NULL);
        break;
    }
    return (fv);
}

// the parent just exits and proceeds to make a client
int createclient(char *client, int fd)
{
    int fv;
    int rc;
    fv =  fork();
    switch (fv)
    {
    case -1:
        perror("fork");
        exit(1);
        break;
    case 0:
        if (fd != 0)
        {
            rc = dup2(fd, 0);
            if (rc < 0)
            {
                perror("client dup");
                exit(1);
            }
        }
        execlp(client, client, NULL);
        break;
    }
    return (fv);
}

int main(int argc, char **argv)
{
    int rc;
    int fds[2];
    int cpid;
    int spid;
    int status = 0;
    if ((rc = socketpair(AF_UNIX, SOCK_STREAM, 0, fds)) == 0)
    {
        spid = createserver(argv[1], fds[0]);
        fprintf(stderr, "server pid=%d\n", spid);
        if (spid > 0)
        {
            cpid = createclient(argv[2], fds[1]);
            fprintf(stderr, "client pid=%d\n", cpid);
        }
    }
    else
    {
        perror("socketpair");
        fprintf(stderr, "the socket pair fucked up!\n");
        return (1);
    }
    return (0);
}
