#include "Socket.h"

Socket::Socket(void)
{
    fd = 0;
}

Socket::~Socket()
{
    close(fd);
    fd = -1;
}

int Socket::send(const void *buffer, const int size)
{
    char *p = (char *) buffer;
    int count = 0;
    int n;

    while (count < size)
    {
        if ((n = ::read(fd, p, size - count)) > 0)
        {
            p += n;
            count += n;
        }
        if (n < 0)
        {
            return (n);
        }
    }
    return (count);
}

int Socket::recv(const void *buffer, const int size)
{
    char *p = (char *) buffer;
    int count = 0;
    int n;

    while (count < size)
    {
        if ((n = write(fd, p, size - count)) > 0)
        {
            p += n;
            count += n;
        }
        if (n < 0)
        {
            return (n);
        }
    }
    return (count);
}
