/*
 * sendFile.cc: sends a file to the socket
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "config.h"
#include "defs.h"
#include "netmessage.h"

int netmessage::sendFile(void)
{
    unsigned char buffer[4096];
    uint32 size;
    int length, rv;

    if ((filedesc = open(filepath, O_RDONLY)) >= 0)
    {
        size = htonl(fileByteCount);

        if ((rv = socket->send((void*) &size, 4)) < 0)
        {
            return rv;
        }

        while (rv > 0 && (length = read(filedesc, buffer, 4096)) > 0)
        {
            rv = socket->send((void*) &buffer[0], length);
        }

        close(filedesc);
        filedesc = -1;
        gotFileHeader = gotfileopen = false;
    }
    else
    {
        size = 0;
        rv = socket->send((void*) &size, 4);
    }
    return rv;
}
