/*
 * recvMember.cc: methods to get data into members
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "config.h"
#include "netmessage.h"

int netmessage::recvMember(char& c)
{
    return getData(&c, 1);
}

int netmessage::recvMember(unsigned char& c)
{
    return getData(&c, 1);
}

int netmessage::recvMember(bool& b)
{
    return getData(&b, sizeof(bool));
}

int netmessage::recvMember(short int& i)
{
    int retc;

    if ((retc = getData(&tmpShort, SIZEOF_SHORT)) == 0)
    {
        i = ntohs(tmpShort);
    }
    return retc;
}

int netmessage::recvMember(unsigned short& i)
{
    int retc;

    if ((retc = getData(&tmpUShort, SIZEOF_SHORT)) == 0)
    {
        i = ntohs(tmpUShort);
    }
    return retc;
}

int netmessage::recvMember(int& i)
{
    int retc;

    if ((retc = getData(&tmpInt, SIZEOF_INT)) == 0)
    {
        i = ntohl(tmpInt);
    }
    return retc;
}

int netmessage::recvMember(unsigned int& i)
{
    int retc;

    if ((retc = getData(&tmpUInt, SIZEOF_INT)) == 0)
    {
        i = ntohl(tmpUInt);
    }
    return retc;
}

int netmessage::recvMember(long& i)
{
    int retc;

    if ((retc = getData(&tmpLong, SIZEOF_LONG)) == 0)
    {
        i = ntohl(tmpLong);
    }
    return retc;
}

int netmessage::recvMember(unsigned long& i)
{
    int retc;

    if ((retc = getData(&tmpULong, SIZEOF_LONG)) == 0)
    {
        i = ntohl(tmpULong);
    }
    return retc;
}

int netmessage::recvMember(long long& i)
{
    int retc;

    if ((retc = getData(&tmpLLong, SIZEOF_LONG_LONG)) == 0)
    {
#ifndef WORDS_BIGENDIAN
            i  = bswap(tmpLLong);
#else
            i = tmpLLong;
#endif
    }
    return retc;
}

int netmessage::recvMember(unsigned long long int& i)
{
    int retc;

    if ((retc = getData(&tmpULLong, SIZEOF_LONG_LONG)) == 0)
    {
#ifndef WORDS_BIGENDIAN
        i = bswap(tmpULLong);
#else
        i = tmpULLong;
#endif
    }
    return retc;
}

int netmessage::recvMember(float& fval)
{
    int retc;

    if ((retc = getData(&tmpFloat, SIZEOF_FLOAT)) == 0)
    {
#ifndef WORDS_BIGENDIAN
            fval = bswap(tmpFloat);
#else
            fval = tmpFloat;
#endif
    }
    return retc;
}

int netmessage::recvMember(double& d)
{
    int retc;

    if ((retc = getData(&tmpDouble, SIZEOF_DOUBLE)) == 0)
    {
#ifndef WORDS_BIGENDIAN
            d = bswap(tmpDouble);
#else
            d = tmpDouble;
#endif
    }
    return retc;
}
