/*
 * recvFile.cc: read data from the socket and write it to a temporary file
 *
 * returns -1 on error, 0 when finished, or the remaining length
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "netmessage.h"

int netmessage::recvFile(void)
{
    char buffer[4096];
    int retc, len, rlen;

    if (gotFileHeader == false)
    {
        if ((retc = getData(&fileByteCount, 4)) == 0)
        {
            fileByteCount = ntohl(fileByteCount);

            if (tmpDataPath->length() + 18 < PATH_MAX)
            {
                /* initialize the temporary file for writing */
                char tmpFile[tmpDataPath->length() + 18];

                strncpy(tmpFile, tmpDataPath->c_str(), tmpDataPath->length() + 1);
                strncat(tmpFile, "olympustmp.XXXXXX", 17);
                tmpFile[tmpDataPath->length() + 17] = '\0';
                
                if ((filedesc = mkstemp(tmpFile)) >= 0)
                {
                    *(char**)currMember->data = new char[tmpDataPath->length() + 18];
                    strncpy(*(char**)(currMember->data), tmpFile, tmpDataPath->length() + 18);
                }
                else
                {
                    cerr << "fileCreationError" << endl;
                    //throw nmFileCreationError();
                }
            }
            else
            {
                cerr << "nameLengthError" << endl;
                //throw nmNameLengthError();
            }

            if (fileByteCount == 0)
            {
                return 0;
            }
            gotFileHeader = true;
        }
        else return retc;
    }

    if (fileByteCount < 4096)
        len = fileByteCount;
    else len = 4096;

    while (fileByteCount > 0 && (rlen = socket->recv(buffer, len)) > 0)
    {
        write(filedesc, buffer, rlen);
        if ((fileByteCount = fileByteCount - rlen) < 4096)
            len = fileByteCount;
        else len = 4096;
    }

    if (rlen < 0)
        return rlen;
    return fileByteCount;
}
