/*
 * receive.cc: reads any data on the socket for the data member list
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include <sys/time.h>
#include "netmessage.h"

int netmessage::receive(void)
{
    struct timeval tv;
    fd_set fd_in;
    int rv(1);

    if (transmitting == false)
    {
        transmitting = true;
        currMember = members->nextMember;
    }

    while (currMember != NULL && rv > 0)
    {
        if (currMember->dataType == nmMemberList::charType)
            rv = recvMember((char&) *currMember->data);
        else if (currMember->dataType == nmMemberList::unsignedcharType)
            rv = recvMember((unsigned char&) *currMember->data);
        else if (currMember->dataType == nmMemberList::charstarType)
            rv = getDynamicData((char**) currMember->data);
        else if (currMember->dataType == nmMemberList::unsignedcharstarType)
            rv = getDynamicData((char**) currMember->data);
        else if (currMember->dataType == nmMemberList::binaryType)
            rv = getBinaryData((char**) currMember->data);
        else if (currMember->dataType == nmMemberList::boolType)
            rv = recvMember((bool&) *currMember->data);
        else if (currMember->dataType == nmMemberList::shortType)
            rv = recvMember((short&) *currMember->data);
        else if (currMember->dataType == nmMemberList::unsignedshortType)
            rv = recvMember((unsigned short&) *currMember->data);
        else if (currMember->dataType == nmMemberList::intType)
            rv = recvMember((int&) *currMember->data);
        else if (currMember->dataType == nmMemberList::unsignedintType)
            rv = recvMember((unsigned int&) *currMember->data);
        else if (currMember->dataType == nmMemberList::longType)
            rv = recvMember((long&) *currMember->data);
        else if (currMember->dataType == nmMemberList::unsignedlongType)
            rv = recvMember((unsigned long&) *currMember->data);
        else if (currMember->dataType == nmMemberList::longlongType)
            rv = recvMember((long long&) *currMember->data);
        else if (currMember->dataType == nmMemberList::unsignedlonglongType)
            rv = recvMember((unsigned long long&) *currMember->data);
        else if (currMember->dataType == nmMemberList::floatType)
            rv = recvMember((float&) *currMember->data);
        else if (currMember->dataType == nmMemberList::doubleType)
            rv = recvMember((double&) *currMember->data);
        else if (currMember->dataType == nmMemberList::fileType)
        {
            if ((rv = recvFile()) == 0)
            {
                close(filedesc);
                filedesc = -1;
            }
        }
    
        if (rv == 0)
            currMember = currMember->nextMember;
        else if (rv < 0)
            return rv;

        /* check to see if there's any data remaining on the socket */
        FD_ZERO(&fd_in);
        FD_SET(socket->getsd(), &fd_in);
        tv.tv_sec = tv.tv_usec = 0;

        if ((rv = select(socket->getsd() + 1, &fd_in, NULL, NULL, &tv)) < 0)
            return rv;
    }

    if (currMember == NULL)
    {
        transmitting = false;
        return 0;
    }
    return 1;
}
