/*
 * nmMemberList.cc: used by netmessage to store data members
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "nmMemberList.h"

nmMemberList::nmMemberList(void* dataPtr, int typeOfData, int newLength = 0)
{
    this->data = dataPtr;
    this->dataType = typeOfData;
    this->length = newLength;
    this->nextMember = NULL;
}

nmMemberList::~nmMemberList(void)
{
    if (this->nextMember != NULL)
    {
        delete nextMember;
    }
}

void nmMemberList::add(void* dataPtr, int typeOfData, int newLength = 0)
{
    nmMemberList* lastItem(this);
    
    while (lastItem->nextMember != NULL)
    {
        lastItem = lastItem->nextMember;
    }
    lastItem->nextMember = new nmMemberList(dataPtr, typeOfData, newLength);
}

void nmMemberList::remove(void* dataPtr)
{
    nmMemberList* tmp(this), *last(NULL);

    while (tmp != NULL)
    {
        if (tmp->data == dataPtr)
        {
            last->nextMember = tmp->nextMember;
            tmp->nextMember = NULL;
            delete tmp;

            break;
        }
        last = tmp;
        tmp = tmp->nextMember;
    }
}

long nmMemberList::sumLength(void)
{
    nmMemberList* memberMarker(this->nextMember);
    long totalLength(this->length);
    
    while (nextMember != NULL)
    {
        totalLength += memberMarker->length;
        memberMarker = memberMarker->nextMember;
    }
    return totalLength - HEADER_SIZE;
}

int nmMemberList::getLongest(void)
{
    nmMemberList* memberMarker(this);
    int longest(this->length);
    
    while (memberMarker->nextMember != NULL)
    {
        if (memberMarker->length > longest)
        {
            longest = memberMarker->length;
        }
        memberMarker = memberMarker->nextMember;
    }
    return longest;
}

int nmMemberList::count(void)
{
    nmMemberList* memberMarker(this);
    int count(1);
    
    while (memberMarker->nextMember != NULL)
    {
        count++;
        memberMarker = memberMarker->nextMember;
    }
    return count;
}
