/*
 * netmessage.cc: sends and receives data across a network connection.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "config.h"
#include "defs.h"
#include "netmessage.h"

netmessage::netmessage(transport* connection, uint32 session_id, uint32 command_id)
{
    socket = connection;

    sessionID = session_id;
    commandID = command_id;

    members = new nmMemberList(NULL, nmMemberList::headerType, HEADER_SIZE);
    
    amtReceived = 0;
    dynamicLength = 0;

    filedesc = -1;

    gotDynamicLength = false;
    gotFileHeader = false;
    transmitting = false;
}

netmessage::~netmessage(void)
{
    delete members;
}

int netmessage::getData(void* buffer, int length)
{
    unsigned char* ptr((unsigned char*) buffer);
    int rlen;

    if ((rlen = socket->recv(ptr + amtReceived, length - amtReceived)) > 0)
    {
        if ((amtReceived = amtReceived + rlen) == length)
        {
            amtReceived = 0;
        }
        return amtReceived;
    }
    return -1;
}

int netmessage::getDynamicData(char** dataPointer)
{
    int rv;

    if (gotDynamicLength == false)
    {
        if ((rv = getData(&dynamicLength, 4)) == 0)
        {
            dynamicLength = ntohl(dynamicLength);
            *dataPointer = new char[dynamicLength+1];
            (*dataPointer)[dynamicLength] = '\0';

            if (dynamicLength == 0)
            {
                return 0;
            }
            gotDynamicLength = true;
        }
        else return rv;
    }

    if ((rv = getData(*dataPointer, dynamicLength)) == 0)
    {
        gotDynamicLength = false;
        dynamicLength = 0;
    }
    return rv;
}

int netmessage::getBinaryData(char** dataPointer)
{
    int rv;

    if (gotDynamicLength == false)
    {
        if ((rv = getData(&dynamicLength, 4)) == 0)
        {
            dynamicLength = ntohl(dynamicLength);
            *dataPointer = new char[dynamicLength];

            if (dynamicLength == 0)
            {
                return 0;
            }
            gotDynamicLength = true;
        }
        else return rv;
    }

    if ((rv = getData(*dataPointer, dynamicLength)) == 0)
    {
        gotDynamicLength = false;
        dynamicLength = 0;
    }
    return rv;
}
