/*********************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * byteswap.cc
 *
 * all the byteswapping methods for netmessage live here.
 *********************************************************************/

#include "netmessage.h"


// return a long long swapped
long long
netmessage::bswap(long long sll)
{
    long long rval = sll;
    bswap(sizeof (long long), (char *) &sll, (char *) &rval);
    return (rval);
}

// return an unsigned long long swapped
unsigned long long
netmessage::bswap(unsigned long long ull)
{
    unsigned long long rval;
    bswap(sizeof (unsigned long long), (char *) &ull, (char *) &rval);
    return (rval);
}

// return a floating point value swapped
float
netmessage::bswap(float fv)
{
    float rval;
    bswap(sizeof (float), (char *) &fv, (char *) &rval);
    return (rval);
}

// return a double precision floating point value swapped
double
netmessage::bswap(double fv)
{
    double rval;
    bswap(sizeof (double), (char *) &fv, (char *) &rval);
    return (rval);
}

// this is a generic byte swap function.  values for in/out must
// not overlap.
void
netmessage::bswap(unsigned int size, char *in, char *out)
{
    char *p;
    char *q;
    unsigned int i;
    p = out;
    q = in + size - 1;
    for (i = 0; i < size; i++)
    {
        *p++ = *q--;
    }
}

