/*
 * transport.h: header for transport layer object
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __transport_h_
#define __transport_h_

#include "config.h"
#include "defs.h"
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <errno.h>

/* external classes */
class cipher;
class DH;

/* exceptions */
class socketCreationError {};

class socketSettingError
{
    public:
        socketSettingError(const char* optname)
        {
            error = optname;
        }
        socketSettingError(const socketSettingError& sockerr)
        {
            error = sockerr.error;
        }
        ~socketSettingError(void)
        {
        }
        const char* error;
};

class socketError
{
    public:
        socketError(const int errcode)
        {
            error = errcode;
        }
        socketError(const socketError& sockerr)
        {
            error = sockerr.error;
        }
        ~socketError(void)
        {
        }
        int error;
};

class transport
{
    public:
        transport(void);
        transport(int nsd);
        ~transport(void);
        
        int getsd(void);
        int bind(char* hostname);
        int bind(char* hostname, int port);
        int connect(char* hostname, int port);
        int listen(int backlog);
        int accept(void);
        int send(const void*, int);
        int recv(void*, int);

        void kexInit(struct BigNum* p, struct BigNum* g);
        void kexGenerate(struct BigNum* f);
        struct BigNum* kexPublic(void);

        void setCipher(int type, bool client);

    private:
        int sd;                                 /* socket descriptor */
        struct sockaddr_in local_addr;          /* local address */
        struct sockaddr_in remote_addr;         /* remote address */
        socklen_t addr_len;                     /* remote address length */

        DH* kex;                                /* key exchange algorithm */

        cipher* encipher;                       /* encryption send context */
        cipher* decipher;                       /* encryption receive context */

        unsigned char header[8];                /* packet header */
        unsigned char* buffer;                  /* receive buffer */
        unsigned char* bptr;                    /* buffer position */

        uint32 packet_length;                   /* expected packet length */
        int padding_length;                     /* padding length */
        int packet_read;                        /* packet length read */
};

#endif /* __transport_h_ */
