/*********************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * sequence.h
 *
 * this manages a sequence of numbers which can be incremented 
 * safely to give unique numbers with a period of INTMAXVAL
 *********************************************************************/

#ifndef SEQUENCE_H
#define SEQUENCE_H

#include <limits.h>

class sequence
{
    public:
        sequence() { value = 0; }
        sequence(int startAt) { value = startAt; }
        
        inline int next() 
        { 
            if (value < INT_MAX) 
            { 
                return ++value; 
            }
            else
            {
                value = 1;
                return value;
            }
        }
        
        inline int current() { return value; }
        
    private:
        int value;
};
#endif
