/*
 * nmMemberList.h: used by netmessage to store data members
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __nmMemberList_h
#define __nmMemberList_h

#include "defs.h"
#include "config.h"

class nmMemberList
{
    public:
        enum {
            headerType,
            charType,
            unsignedcharType,
            charstarType,
            unsignedcharstarType,
            binaryType,
            boolType,
            shortType,
            unsignedshortType,
            intType,
            unsignedintType,
            longType,
            unsignedlongType,
            longlongType,
            unsignedlonglongType,
            floatType,
            doubleType,
            fileType
        };

        void* data;
        int dataType;
        int length;
        nmMemberList* nextMember;

        nmMemberList(void* dataPtr, int typeOfData, int newLength = 0);
        ~nmMemberList(void);
        
        void add(void* dataPtr, int typeOfData, int newLength);
        void remove(void* dataPtr);
        int getLongest(void);
        int count(void);
        long sumLength(void);
   
    private:
        nmMemberList(void);
};

#endif /* __nmMemberList_h */
