/*
 * msgs.h: definitions of operation codes used to differentiate between
 * transmission types.
 *
 * Copyright (c) 1999-2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __msgs_h_
#define __msgs_h_

/* transport layer generic operation codes (1-19) */
#define CHANNEL_CLOSE                1
#define CHANNEL_ERROR                2
#define CHANNEL_FILEERROR            3

/* protocol and connection negotiation (20-39) */
#define PROTOCOL_VERSION            20

/* algorithm negotiation (40-49) */
#define ALG_INIT                    40
#define ALG_SUCCESS                 41
#define ALG_FAILURE                 42

/* key exchange (50-59) */
#define KEX_DH_INIT                 50
#define KEX_DH_REPLY                51

/* user authentication (60-69) */
#define USERAUTH_REQUEST            60
#define USERAUTH_SUCCESS            61
#define USERAUTH_FAILURE            62

/* transport layer buffer handling codes (70-89) */
#define NETMESSAGE                  70
#define NETMESSAGE_SUCCESS          71
#define NETMESSAGE_FAILURE          72

#endif /* __msgs_h_ */
