/*
 * exceptions.h: common exceptions thrown
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __exceptions_h_
#define __exceptions_h_

#include <string>

/* file io errors */
class fileOpenError
{
    public:
        fileOpenError(const char *file)
        {
            filename = file;
        }
        fileOpenError(const fileOpenError &error)
        {
            filename = error.filename;
        }
        ~fileOpenError(void)
        {
        }
        const char *filename;
};

class fileCreateError
{
    public:
        fileCreateError(const char *file)
        {
            filename = file;
        }
        fileCreateError(const fileCreateError &error)
        {
            filename = error.filename;
        }
        ~fileCreateError(void)
        {
        }
        const char *filename;
};

#endif /* __exceptions_h_ */
