/*
 * defs.h: common global definitions
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __defs_h_
#define __defs_h_

#include <string>

class CSPRNG;

/* data paths which are defined at and may be changed during runtime */
extern string *baseOlympusPath;
extern string *tmpDataPath;

/* random number generator */
extern CSPRNG *RNG;

/* the default server port */
#define SERVER_PORT                 569

/* size of netmessage headers */
#define HEADER_SIZE                 32

#if SIZEOF_INT == 2
typedef int int16;
typedef unsigned int uint16;
#else
#if SIZEOF_SHORT == 2
typedef short int16;
typedef unsigned short uint16;
#endif
#endif

#if SIZEOF_INT == 4
typedef int int32;
typedef unsigned int uint32;
#else
#if SIZEOF_LONG == 4
typedef long int32;
typedef unsigned long uint32;
#endif
#endif

#if SIZEOF_INT == 8
typedef int int64;
typedef unsigned int uint64;
#else
#if SIZEOF_LONG == 8
typedef long int64;
typedef unsigned long uint64;
#else
#if SIZEOF_LONG_LONG == 8
typedef long long int64;
typedef unsigned long long uint64;
#endif
#endif
#endif

#endif /* __defs_h_ */
