/*
 * commid.h: command object id codes
 *
 * Copyright (c) 1999-2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __commid_h_
#define __commid_h_

/* 1-9: network connection */
#define COMMAND_VERSION             1
#define COMMAND_ALGINIT             2
#define COMMAND_KEXINIT             3
#define COMMAND_KEXREPLY            4
#define COMMAND_USERAUTH            5

/* 11-19: olympus user management */
#define COMMAND_USERS              11
#define COMMAND_GETUSERNAMES       12

/* 21-30: executable commands */
#define COMMAND_EXEC               21
#define COMMAND_SETEXEC            22

/* 31-35: config files */
#define COMMAND_FETCHCONFIG        31
#define COMMAND_UPDATECONFIG       32

/* 36-40: System Monitoring */
#define COMMAND_SYSINFO            36

/* 41-50: utility messages */
#define COMMAND_PING               41
#define COMMAND_STRSTREAM          42

/* 51-60: software install */
#define COMMAND_BUILDSRC           51
#define COMMAND_CONFIGSRC          52
#define COMMAND_EXPANDSRC          53
#define COMMAND_INFOSRC            54
#define COMMAND_INSTALLSRC         55
#define COMMAND_LISTSRC            56

/* 150-199: success messages*/
#define COMMAND_SUCCESS           150

/* 200+: failure messages*/
#define COMMAND_ERROR             200  /* never use this as an actual netmessage
                                          it is merely for making the code that
                                          checks for errors clean, good looking,
                                          and maintainable. 
                                          
                                          e.g.: if (commandID > COMMAND_ERROR)
                                          */
#define COMMAND_UNKNOWNTOHOST     201
#define COMMAND_FILENOTFOUND      202
#define COMMAND_PERMISSIONDENIED  203

#endif /* __commid_h_ */
