/*
 * update.cc: update any record in the database matching the given record
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::update(const char* key1, const char* key2, const char* value, const char* newvalue)
{
    intarray* keyarray1, *keyarray2, *intersect;
    char* dbvalue;
    int i, n, pos;

    if (!(keyarray1 = hash_table1[key1]) || !(keyarray2 = hash_table2[key2]))
    {
        return;
    }
    
    intersect = *keyarray1 || *keyarray2;

    n = intersect->count();

    for (i = 0; i < n; i++)
    {
        pos = (*intersect)[i];

        dbvalue = fileRead(pos);

        if (strcmp(dbvalue, value) == 0)
        {
            update(key1, key2, newvalue, pos);
        }
        delete dbvalue;
    }
    delete intersect;
}

void Database::update(const char* key1, const char* key2, const char* newvalue, int pos)
{
    int offset;

    try {
        offset = fileWrite(pos, key1, key2, newvalue);
    }

    catch (dbOutOfSync)
    {
        hashBuild();
        offset = fileWrite(pos, key1, key2, newvalue);
    }


    if (offset != pos)
    {
        const char* nkey1, *nkey2;

        nkey1 = strdup(key1);
        nkey2 = strdup(key2);

        hashRemove(nkey1, nkey2, pos);
        hashAdd(nkey1, nkey2, offset);
    }
}
