/*
 * removeKey2.cc: lookup the intarray for key 2 and delete all occurences of
 * the key from the database.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::removeKey2(const char* key2)
{
    intarray* keyarray;
    char* key1;
    int i, n, pos;
    
    if (! (keyarray = hash_table2[key2])) 
    { 
        return; 
    }
 
    n = keyarray->count();
 
    for (i = 0; i < n; i++)
    {
        pos = (*keyarray)[i];

        try {
            key1 = fileReadKey1(pos);
        }

        catch (dbBadFormat)
        {
        }

        catch (dbSeekFail)
        {
        }
        
        catch (dbReadFail)
        {
        }

        hashRemove(key1, key2, pos);
        fileRemove(pos);

        delete key1;
    }
}
