/*
 * removeKey1.cc: lookup the intarray for key 1 and delete all occurences of
 * the key from the database.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::removeKey1(const char* key1)
{
    intarray* keyarray;
    char* key2;
    int i, n, pos;

    cerr << "dkht::removeKey1() key1 = \"" << key1 << "\"" << endl;

    if (! (keyarray = hash_table1[key1])) 
    { 
        cerr << "dkht::removeKey1() didn't find any matching entries." << endl;
        return; 
    }

    n = keyarray->count();
    cerr << "dkht::removeKey1() found " << n << " matching entries." << endl;

    for (i = 0; i < n; i++)
    {
        pos = (*keyarray)[i];

        try {
            key2 = fileReadKey2(pos);
        }

        catch (dbBadFormat)
        {
        }

        catch (dbSeekFail)
        {
        }

        catch (dbReadFail)
        {
        }

        hashRemove(key1, key2, pos);
        fileRemove(pos);

        delete key2;
    }
}
