/*
 * removeAll.cc: remove all records containing key1 and key2 from the database
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::removeAll(const char* key1, const char* key2)
{
    intarray* keyarray1, *keyarray2, *intersect;
    int i, n, pos;

    if (! (keyarray1 = hash_table1[key1]) || ! (keyarray2 = hash_table2[key2]))
    {
        return;
    }
    
    intersect = *keyarray1 || *keyarray2;

    n = intersect->count();

    for (i = 0; i < n; i++)
    {
        pos = (*intersect)[i];

        hashRemove(key1, key2, pos);
        fileRemove(pos);
    }
    delete intersect;
}
