/*
 * remove.cc: remove all records with matching key1/key2/value from the database
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::remove(const char* key1, const char* key2, const char* value)
{
    intarray* keyarray1, *keyarray2, *intersect;
    char* dbvalue;
    int i, n, pos;

    if (! (keyarray1 = hash_table1[key1]) || ! (keyarray2 = hash_table2[key2]))
    {
        return;
    }
    
    intersect = *keyarray1 || *keyarray2;

    n = intersect->count();

    for (i = 0; i < n; i++)
    {
        pos = (*intersect)[i];

        try {
            dbvalue = fileRead(pos);
        }

        catch (dbBadFormat)
        {
        }

        catch (dbSeekFail)
        {
        }

        catch (dbReadFail)
        {
        }

        if (strcmp(value, dbvalue) == 0)
        {
            hashRemove(key1, key2, pos);
            fileRemove(pos);
        }
        delete dbvalue;
    }
    delete intersect;
}
