/*
 * readAll.cc: get all appplicable key1/key2 combinations from the database
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

vector<char *>* Database::readAll(const char* key1, const char* key2)
{
    vector<char *>* values;
    intarray* records;
    int i(0), numrecords;

    if (! (records = hashGetAll(key1, key2)))
    {
        return NULL;
    }
    
    numrecords = records->count();
    values = new vector<char *>(numrecords);
    
    for (; i < numrecords; i++)
    {
        values->push_back(fileRead((*records)[i]));
    }

    delete records;
    return values;
}
