/*
 * insert.cc: write a record to the database and add it to the hash tables
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::insert(const char* key1, const char* key2, const char* value)
{
    unsigned long pos, offset;
    const char *nkey1, *nkey2;

    nkey1 = strdup(key1);
    nkey2 = strdup(key2);
    
    pos = fileWrite(0, nkey1, nkey2, value);
    hashAdd(nkey1, nkey2, pos);
}
