/*
 * writeRecord.cc: write a record to the database file at its current position
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

unsigned long
Database::writeRecord(uint32 recordsize, const char* key1, const char* key2, const char* value)
{
    char recordHeader[DB_HEADER_SIZE];
    uint32 key1size, key2size, valsize;
    int len;

    key1size = strlen(key1);
    key2size = strlen(key2);
    valsize = strlen(value);

    memcpy(&recordHeader[0], &recordsize, 4);
    memcpy(&recordHeader[4], &key1size, 4);
    memcpy(&recordHeader[8], &key2size, 4);
    memcpy(&recordHeader[12], &valsize, 4);
    memset(recordHeader+16, 0, 16);

    /* FIXME: we really need some error checking here */
    len = ::write(dbfd, recordHeader, DB_HEADER_SIZE);
    len += ::write(dbfd, value, valsize);
    len += ::write(dbfd, key1, key1size);
    len += ::write(dbfd, key2, key2size);

    return len;
}
