/*
 * updateDefragTime.cc: update the database defrag time record to the current time
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::updateDefragTime(int fd)
{
    uint32 tval;
    int offset;

    defragTime = time(NULL);
    tval = defragTime;

    offset = lseek(fd, 0, SEEK_CUR);
    lseek(fd, 20, SEEK_SET);
    ::write(fd, &defragTime, 4);
    lseek(fd, offset, SEEK_SET);
}
