/*	intarry class
	implements a class that handles a dynamic array of ints
	most importantly, it allows you to do unions.
	aka "quick hack"
	
	Aaron J. Seigo
*/

#include "intarray.h"

intarray::intarray(int size = 0)
{
	linkedInt * newLInt;
	numElements = size;
	if (size > 0)
	{
		newLInt = theseInts = new linkedInt(0);
		for (int i = 1; i < size; i++)
		{
			newLInt->setNext(new linkedInt(0));
			newLInt = newLInt->next();
		}
	}
}

int intarray::add(int newInt)
{
	if (numElements == 0)
	{
		theseInts = new linkedInt(newInt);
	}
	else
	{
		linkedInt * thisInt = theseInts;
		while (thisInt->next()) { thisInt = thisInt->next(); }
		
		thisInt->setNext(new linkedInt(newInt));
	}
	numElements++;
	return numElements;
}

bool intarray::rem(int value)
{
	linkedInt * remInt = theseInts;
	
	if (value == theseInts->value())
	{
	    if (numElements == 1) { theseInts == 0; }
	    else { theseInts = theseInts->next(); }
    	
    	delete remInt;
    	numElements--;
    	return true;
	}
	else
	{	
    	linkedInt * prevInt = theseInts;
		
		while(remInt)
		{
			if (value == remInt->value()) { break; }
			else
			{
				prevInt = remInt;
				remInt = remInt->next();
			}
		}
		
    	if (remInt)
    	{
    	    prevInt->setNext(remInt->next());
            
       		delete remInt;
      		numElements--;
            return true;
    	}
    	else { return false; }
	}
}

linkedInt* intarray::find(int intToFind)
{
	linkedInt * found = theseInts;
	
	while (found)
	{
		if (*found == intToFind) { break; }
		else { found = found->next(); }
	}
	
    return found;
}

linkedInt* intarray::find(linkedInt* intToFind)
{
	linkedInt* found = theseInts;
	
	while (found)
	{
		if (*found == *intToFind) { break; }
		else { found = found->next(); }
	}
	
	return found;
}

int intarray::operator|(intarray otherArray)
{
	linkedInt * us = theseInts;
	linkedInt * them = otherArray.getFirst();
	int i, j;
	int intersect = -1;
	int otherCount = otherArray.count();
	
	for (i = 0; i < numElements && intersect == -1; i++)
	{
		for (j = 0; j < otherCount && intersect == -1; j++)
		{
			if (*us == *them) { intersect = us->value(); }
			else { them = them->next(); }
		}
		
		us = us->next();
		them = otherArray.getFirst();
	}
	
	return intersect;
}


intarray * intarray::operator||(intarray otherArray)
{
	linkedInt* us = theseInts;
	linkedInt* them = otherArray.getFirst();
	intarray* intersect = new intarray;
	int i, j;
	int otherCount = otherArray.count();
	
	for (i = 0; i < numElements; i++)
	{
		for (j = 0; j < otherCount; j++)
		{
			if (*us == *them) { intersect->add(us->value()); break; }
			else { them = them->next(); }
		}
		
		us = us->next();
		them = otherArray.getFirst();
	}
	
	return intersect;
}

int intarray::operator[](int pos)
{
	if (pos > numElements) { return 0; }
	
	linkedInt* returnThis = theseInts;
	for (int i = 0; i < pos; i++) { returnThis = returnThis->next(); }
	
	return returnThis->value();
}
