/*
 * hashRemove.cc: remove two corresponding keys from the hash table
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::hashRemove(const char* key1, const char* key2)
{
    intarray *keyarray1, *keyarray2, *intersect;
    int toRemove, i;

    if (! (keyarray1 = hash_table1[key1]) || ! (keyarray2 = hash_table2[key2]))
    {
        return;
    }

    intersect = *keyarray1 || *keyarray2;
    toRemove = intersect->count();
    
    for (i = 0; i < toRemove; i++)
    {
        keyarray1->rem((*intersect)[i]);
        keyarray2->rem((*intersect)[i]);
    }
    delete intersect;
}

void Database::hashRemove(const char* key1, const char* key2, unsigned long pos)
{
    intarray *keyarray1, *keyarray2;

    if (! (keyarray1 = hash_table1[key1]) || ! (keyarray2 = hash_table2[key2]))
    {
        return;
    }
    
    keyarray1->rem(pos);
    keyarray2->rem(pos);
}
