/*
 * hashGetAll.cc: returns an intarray containing all of the intersections in
 * the hash table for key1 and key2
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

intarray* Database::hashGetAll(const char* key1, const char* key2)
{
    intarray* keyarray1, *keyarray2, *intersect;

    if (! (keyarray1 = hash_table1[key1]) || ! (keyarray2 = hash_table2[key2]))
    {
        return 0;
    }
    
    intersect = *keyarray1 || *keyarray2;

    return intersect;
}
