/*
 * hashGet.cc: get the position of the record containing two corresponding
 * keys in the database.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

unsigned long Database::hashGet(const char* key1, const char* key2)
{
    intarray* keyarray1, *keyarray2;

    keyarray1 = hash_table1[key1];
    keyarray2 = hash_table2[key2];

    if (keyarray1 == NULL || keyarray2 == NULL || keyarray1->count() == 0 || keyarray2->count() == 0)
    {
        return 0;
    }
    return *keyarray1 | *keyarray2;
}
