/*
 * hashBuild.cc: build hash table from database file
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::hashBuild(void)
{
    unsigned long offset;
    char* key1, *key2;

    if ((offset = fileReset()) < DB_HEADER_SIZE)
    {
        throw dbSeekFail();
    }

    while ((offset = fileReadNext(key1, key2)) != 0)
    {
        hashAdd(key1, key2, offset);
    }
}
