/*
 * hashAdd.cc: add the locations of a record to the hash tables
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::hashAdd(const char* key1, const char* key2, unsigned long pos)
{
    intarray* int1, *int2;
    
    if ((int1 = hash_table1[key1]) > 0)
    {	
        int1->add(pos);
    }
    else
    {
        int1 = new intarray();
        hash_table1[key1] = int1;
        int1->add(pos);
    }

    if ((int2 = hash_table2[key2]) > 0)
    {
        int2->add(pos);
    }
    else
    {
        int2 = new intarray();
        hash_table2[key2] = int2;
        int2->add(pos);
    }	
}
