/*
 * fileWrite.cc: write data to the database
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

unsigned long
Database::fileWrite(unsigned long offset, const char* key1, const char* key2, const char* value)
{
    uint32 pos, rsize, wsize;

    rsize = (DB_HEADER_SIZE - 4) + strlen(key1) + strlen(key2) + strlen(value);

    /* malformed file header */
    if ((pos = lseek(dbfd, 0, SEEK_END)) < DB_HEADER_SIZE)
    {
        throw dbBadFormat();
    }

    /* check to see if the keys exist at the given offset */
    if (offset > 0)
    {
        /* if we can't find the keys in the file, the database is out of sync */
        if (!checkOffset(offset, key1, key2))
        {
            throw dbOutOfSync();
        }

        if (lseek(dbfd, offset, SEEK_SET) != offset) 
        {
            throw dbSeekFail();        
        }

        if (::read(dbfd, &wsize, 4) != 4)
        {
            throw dbReadFail();
        }

        /* ensure that there is enough space for the new record */
        if ((wsize & DELETE_RECORD) < rsize || (wsize & DELETE_RECORD) > rsize)
        {
            /* mark the current record for deletion */
            if (lseek(dbfd, -4, SEEK_CUR) != offset)
            {
                throw dbSeekFail();
            }

            wsize = wsize | RECORD_DELETE;

            if (::write(dbfd, &wsize, 4) != 4)
            {
                throw dbWriteFail();           
            }

            /* find a position that has enough space for the new record */
            pos = fileSeekEmpty(rsize);
        }
    }

    /* write the record the offset position */
    if (lseek(dbfd, pos, SEEK_SET) != pos)
    {
        throw dbSeekFail();
    }
    wsize = writeRecord(rsize, key1, key2, value);

    return (wsize > 0) ? pos : 0;
}
