/*
 * fileSize.cc: returns the size in bytes of the database file, minus the size
 * of the header.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

unsigned long Database::fileSize(void)
{
    struct stat finfo;

    if (stat(dbfile, &finfo) == 0)
    {
        if (finfo.st_size >= DB_HEADER_SIZE)
        {
            return finfo.st_size - DB_HEADER_SIZE;
        }
        else
        {
            throw dbBadFormat();
        }
    }
    else
    {
        throw dbStatFail();
    }
}
