/*
 * fileSeekEmpty.cc: locate a region of the file that is minimally larger (or
 * the same) as the requested size.
 *
 * 05/01/00 cairnsc: this now only finds records that are the same size as
 * as recordsize, otherwise it will just return a position at the end of the
 * file.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

unsigned long Database::fileSeekEmpty(uint32 recordsize)
{
    uint32 pos, offset, rsize;

    if ((pos = fileReset()) != DB_HEADER_SIZE)
    {
        throw dbSeekFail();
    }

    while (::read(dbfd, &rsize, 4) == 4)
    {
        if (rsize & RECORD_DELETE)
        {
            if ((rsize & DELETE_RECORD) == recordsize)
            {
                break;
            }
        }

        rsize = rsize & DELETE_RECORD;

        if ((offset = lseek(dbfd, rsize, SEEK_CUR)) != pos + rsize + 4)
        {
            throw dbSeekFail();
        }
        pos = offset;
    }
    return pos;
}
