/*
 * fileRemove.cc: mark a record for deletion at the given database position
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::fileRemove(unsigned long pos)
{
    uint32 recordsize;
    struct stat finfo;

    if (stat(dbfile, &finfo) == 0)
    {
        if (pos >= DB_HEADER_SIZE && pos <= finfo.st_size)
        {
            if (lseek(dbfd, pos, SEEK_SET) != pos)
            {
                throw dbSeekFail();
            }

            if (::read(dbfd, &recordsize, 4) == 4)
            {
                if (!(recordsize & RECORD_DELETE))
                {
                    if (lseek(dbfd, -4, SEEK_CUR) != pos)
                    {
                        throw dbSeekFail();
                    }

                    recordsize = recordsize | RECORD_DELETE;

                    if (::write(dbfd, &recordsize, 4) != 4)
                    {
                        throw dbWriteFail();
                    }
                }
            }
            else
            {
                throw dbReadFail();
            }
        }
        else
        {
            throw dbBadFormat();
        }
    }
    else
    {
        throw dbStatFail();
    }
}
