/*
 * fileReadNext.cc: read the next record from the current database position, modify
 * key1 and key2 to point to the data read
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

int Database::fileReadNext(char*& key1, char*& key2)
{
    char recordHeader[DB_HEADER_SIZE];
    uint32 recordsize, key1size, key2size, valsize;
    uint32 offset, pos;
    int len;

    if ((offset = lseek(dbfd, 0, SEEK_CUR)) < DB_HEADER_SIZE)
    {
        throw dbBadFormat();
    }

    while ((len = ::read(dbfd, recordHeader, DB_HEADER_SIZE)) == DB_HEADER_SIZE)
    {
        memcpy(&recordsize, &recordHeader[0], 4);

        if (!(recordsize & RECORD_DELETE))
        {
            memcpy(&key1size, &recordHeader[4], 4);
            memcpy(&key2size, &recordHeader[8], 4);
            memcpy(&valsize, &recordHeader[12], 4);

            if (lseek(dbfd, valsize, SEEK_CUR) != offset + DB_HEADER_SIZE + valsize)
            {
                throw dbSeekFail();
            }

            key1 = new char[key1size+1];
            key1[key1size] = '\0';
            key2 = new char[key2size+1];
            key2[key2size] = '\0';

            if (::read(dbfd, key1, key1size) != key1size)
            {
                delete[] key1;
                delete[] key2;

                throw dbReadFail();
            }

            if (::read(dbfd, key2, key2size) != key2size)
            {
                delete[] key1;
                delete[] key2;

                throw dbReadFail();
            }

            return offset;
        }
        else
        {
            recordsize = recordsize & DELETE_RECORD;
            pos = offset;

            if ((offset = lseek(dbfd, recordsize, SEEK_CUR)) != pos + recordsize)
            {
                throw dbSeekFail();
            }
        }
    }
    return 0;
}
